import {
    View,
    Text,
    Pressable,
    TouchableOpacity,
    StyleSheet,
    FlatList,
} from "react-native";
import React from "react";
import { ratingAndReviewsStyle } from "./RatingAndReviewsStyle";
import Rightcon from "../../../../../assets/svgs/product details/rightIcon.svg";
import dpr from "../../../../Utilities/CustomStyleAttribute/dpr";
import { useNavigation } from "@react-navigation/native";
import { useEffect } from "react";
import { reviewStyle } from "./Reviews/reviewStyle";
import SignatureIcon from "../../../../../assets/svgs/product details/signature 1.svg";
import usePreferences from "../../../../../hooks/usePreferences";
import { BASE_API_URL_STG } from "@env";
import CustomRating from "../../../../Utilities/CustomRating/CustomRating";
import { round } from "../../../../../helper/ratingRound";
import ProgressiveImage from "../../../../../src/components/ProgressiveImage";
import { MaterialIcons } from "@expo/vector-icons";
import ReviewImages from "./ReviewImages";
import useLangTranslation from "../../../../../hooks/useLangTranslation";
import ReviewSkeleton from "./WriteReviews/ReviewSkeleton";
import { useState } from "react";
import { queryResponse } from "../../../../../redux/slices/util/processResponse";
import CustomSVG from "../../../../../src/components/CustomSVG/CustomSVG";

const RatingAndReviews = ({ productDetails, setProductDetails }) => {
    const { trans } = useLangTranslation();
    const { id, review_average, can_review } = productDetails?.data;
    let rating,
        avgRating,
        cumRating = [];
    let reviewImages = [];
    const URL = `${BASE_API_URL_STG}/user/reviews/${id}`;
    const navigation = useNavigation();
    
    const [Reviews, setReviews] = useState([]);
    const [nextPageUrl, setNextPageUrl] = useState(null);
    const [loading, setLoading] = useState(true);
    const {
        product_general: { reviews_verified_owner_label, rating_enable } = {},
    } = usePreferences();

    useEffect(() => {
        (async() => {
            let isMounted = true;
            if (isMounted) {
                setLoading(true)
                try {
                    const res = await queryResponse(URL, 'GET');
                    const { records, status: { code } = {} } = res || {};
                    const { data, pagination } = records || {};
                    if (code == 200) {
                        setReviews(data)
                        setNextPageUrl(pagination?.next_page_url)
                    } else {
                        setReviews(Reviews)
                    }
                    setLoading(false)
                } catch (error) {}
            }
            return () => {
                isMounted = false;
            };
        })()
    }, []);

    if (Reviews?.length) {
        for (let item of Reviews) {
            if (item?.image?.length > 0) {
                reviewImages = [...reviewImages, ...item?.image];
            }
        }
        rating = Reviews.map((review) => parseInt(review.rating));
        cumRating = rating.reduce((partialSum, a) => partialSum + a, 0);
        avgRating = cumRating / Reviews?.length;
    }
    return (
        <>
            <View style={ratingAndReviewsStyle.subCont}>
                {loading ? (
                    <ReviewSkeleton />
                ) : Reviews?.length > 0 ? (
                    <View style={ratingAndReviewsStyle.container}>
                        <View style={ratingAndReviewsStyle.titleCont}>
                            <Text style={ratingAndReviewsStyle.title}>
                                {trans("Rating & Reviews: {{x}} ({{y}})", {
                                    x: Number(review_average).toFixed(1),
                                    y: Reviews.length,
                                })}
                            </Text>
                        </View>
                        <View>
                            <View style={ratingAndReviewsStyle.userCont}>
                                <View style={ratingAndReviewsStyle.userSubCont}>
                                    <ProgressiveImage
                                        source={{ uri: Reviews[0].user_image }}
                                        style={ratingAndReviewsStyle.userImg}
                                    />
                                    <View>
                                        <Text
                                            style={
                                                ratingAndReviewsStyle.userName
                                            }
                                        >
                                            {Reviews[0].user_name}
                                        </Text>
                                        <Text
                                            style={ratingAndReviewsStyle.time}
                                        >
                                            {Reviews[0].created_at}
                                        </Text>
                                        {(reviews_verified_owner_label == "0" ||
                                            Reviews[0]?.verified_purchase) && (
                                            <View
                                                style={
                                                    ratingAndReviewsStyle.userVerify
                                                }
                                            >
                                                <MaterialIcons
                                                    name="verified-user"
                                                    size={16}
                                                    color="#FCCA19"
                                                />
                                                <Text
                                                    style={
                                                        ratingAndReviewsStyle.userVerifyText
                                                    }
                                                >
                                                    {trans("Verified Purchase")}
                                                </Text>
                                            </View>
                                        )}
                                    </View>
                                </View>
                                {rating_enable == 1 && (
                                    <CustomRating
                                        starSize={dpr(17)}
                                        rating={round(Reviews[0].rating)}
                                        readOnly={true}
                                    />
                                )}
                            </View>
                            <Text style={ratingAndReviewsStyle.text}>
                                {Reviews[0].comments}
                            </Text>
                            <View style={ratingAndReviewsStyle.reviewImgCont}>
                                {Reviews[0]?.image?.length > 5 && (
                                    <Pressable
                                        style={
                                            ratingAndReviewsStyle.imageSeeAll
                                        }
                                        onPress={() =>
                                            navigation.navigate(
                                                "reviewImageGallery",
                                                {
                                                    images: Reviews[0].image,
                                                }
                                            )
                                        }
                                    >
                                        <Text
                                            style={
                                                ratingAndReviewsStyle.imageSeeAllText
                                            }
                                        >
                                            {trans("See All")}
                                        </Text>
                                    </Pressable>
                                )}
                                <FlatList
                                    data={Reviews[0].image}
                                    keyExtractor={(_, index) => "key" + index}
                                    renderItem={({ item, index }) => (
                                        <ReviewImages
                                            image={item}
                                            index={index}
                                            data={Reviews[0].image}
                                            imageStyle={
                                                ratingAndReviewsStyle.reviewImg
                                            }
                                        />
                                    )}
                                    horizontal
                                    scrollEnabled={false}
                                    showsHorizontalScrollIndicator={false}
                                />
                            </View>
                            {Reviews?.length > 0 && <View style={ratingAndReviewsStyle.seeAllBorder}>
                                <TouchableOpacity
                                    style={ratingAndReviewsStyle.seeAllCont}
                                    onPress={() =>
                                        navigation.navigate("reviews", {
                                            avgRating: avgRating,
                                            productDetails:
                                                productDetails?.data,
                                            setProductDetails:
                                                setProductDetails,
                                            reviewImages: reviewImages,
                                            Reviews,
                                            nextPageUrl,
                                            setReviews
                                        })
                                    }
                                >
                                    <Text
                                        style={ratingAndReviewsStyle.seeAllText}
                                    >
                                        {trans("See All")}
                                    </Text>
                                    <CustomSVG svgIcon={Rightcon} isRtl={1}
                                        width={dpr(11)}
                                        height={dpr(11)}
                                        fill={"#898989"}
                                    />
                                </TouchableOpacity>
                            </View>}
                        </View>
                    </View>
                ) : (
                    <View style={style.noRevContainer}>
                        <View style={style.noReviewSubCont}>
                            <View style={style.rating}>
                                <CustomRating
                                    rating={0}
                                    starSize={dpr(18)}
                                    readOnly={true}
                                />
                            </View>
                            <View style={style.noRevTwice}>
                                <Text style={style.noRevText}>
                                    {trans("No Reviews Yet")}
                                </Text>
                                <Text
                                    style={[
                                        style.noRevText,
                                        style.firstRevtext,
                                    ]}
                                >
                                    {trans("Be the first to review this item")}
                                </Text>
                            </View>

                            {can_review && <TouchableOpacity
                                style={[
                                    reviewStyle.writeReview,
                                    style.writeRevCon,
                                ]}
                                onPress={() =>
                                    navigation.navigate("Write a Review", {
                                        reviews: Reviews,
                                        productDetails: productDetails?.data,
                                        avgRating: avgRating,
                                    })
                                }
                            >
                                <CustomSVG svgIcon={SignatureIcon}
                                    height={dpr(24)}
                                    width={dpr(24)}
                                />
                                <Text style={reviewStyle.writeText}>
                                    {trans("Write a Review")}
                                </Text>
                            </TouchableOpacity>}
                        </View>
                    </View>
                )}
            </View>
        </>
    );
};

export default RatingAndReviews;

const style = StyleSheet.create({
    noRevContainer: {
        backgroundColor: "white",
        paddingVertical: dpr(20),
    },
    noReviewSubCont: {
        borderWidth: 1,
        borderColor: "#DFDFDF",
        borderRadius: dpr(6),
        paddingVertical: dpr(20),
    },
    noRevTwice: {
        paddingVertical: dpr(12)
    },
    rating: {
        flexDirection: "row",
        justifyContent: "center",
    },
    noRevText: {
        fontSize: dpr(16),
        color: "#898989",
        fontFamily: "DMSans_500Medium",
        textAlign: "center",
    },
    firstRevtext: {
        color: "#2c2c2c",
        paddingTop: dpr(20),
        fontSize: dpr(14),
    },
    writeRevCon: {
        backgroundColor: "#F3F3F3",
        paddingVertical: dpr(13),
        marginHorizontal: dpr(40),
        borderRadius: dpr(6),
    },
});
